/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Component
implements VerificationConstants {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    protected static MessageBundle s_prveMsgBundle = VerificationUtil.getMessageBundle("Prve");
    public static final int VERIFY_SPACE_AVAIL = 1;
    public static final int VERIFY_SHARED_ACCESS = 2;
    public static final int VERIFY_SYSTEM_REQUIREMENTS = 3;
    public static final int VERIFY_ADMIN_PRIVILEGES = 4;
    public static final int VERIFY_CFS_INTEGRITY = 5;
    public static final int VERIFY_CLUSTER_MGR_INTEGRITY = 6;
    public static final int VERIFY_CLUSTER_INTEGRITY = 7;
    public static final int VERIFY_OCR_INTEGRITY = 8;
    public static final int VERIFY_CRS_INTEGRITY = 9;
    public static final int VERIFY_NODE_CONNECTIVITY = 10;
    public static final int VERIFY_NODE_REACHABILITY = 11;
    public static final int VERIFY_PEER_COMPATIBILITY = 12;
    public static final int VERIFY_NODEAPP_EXISTENCE = 13;
    public static final int VERIFY_OLR_INTEGRITY = 14;
    public static final int VERIFY_HA_INTEGRITY = 15;
    public static final int VERIFY_SOFTWARE = 16;
    public static final int VERIFY_ACFS_INTEGRITY = 17;
    public static final int VERIFY_OS_COMPAT_VERSION = 18;
    public static final int VERIFY_GPNP_INTEGRITY = 19;
    public static final int VERIFY_GNS_INTEGRITY = 20;
    public static final int VERIFY_SCAN = 21;
    public static final int VERIFY_OHASD_INTEGRITY = 22;
    public static final int VERIFY_ASM_INTEGRITY = 23;
    public static final int VERIFY_CTSS_INTEGRITY = 24;
    public static final int VERIFY_VDISK_INTEGRITY = 25;
    public static final int VERIFY_HEALTH = 26;
    public static final int VERIFY_DNS_INTEGRITY = 27;
    public static final int VERIFY_DHCP_INTEGRITY = 28;
    public static final int VERIFY_HEALTH_CHECK = 29;
    public static final int VERIFY_FREE_SPACE_GRID = 30;
    public static final int VERIFY_FARM_CHECK = 31;
    public static final int VERIFY_BASELINE = 32;
    protected String[] m_nodeList;
    protected String[] m_validNodeList;
    protected int m_verificationType;
    protected ParamManager m_paramMgr;
    protected ResultSet m_resultSet = new ResultSet();

    public void init() throws ComponentInitException {
        this.init(true);
    }

    public void init(boolean initNodelist) throws ComponentInitException {
        try {
            this.m_paramMgr = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            throw new ComponentInitException(e.getMessage());
        }
        if (initNodelist) {
            String autoNodeListStr = VerificationUtil.getVariableValue("AUTO_LIST");
            String hubNodeListStr = VerificationUtil.getVariableValue("HUB_LIST");
            String rimNodeListStr = VerificationUtil.getVariableValue("RIM_LIST");
            String targetHubSizeStr = VerificationUtil.getVariableValue("TARGET_HUB_SIZE");
            if (autoNodeListStr != null || hubNodeListStr != null || rimNodeListStr != null) {
                boolean targetHubSize = false;
                ArrayList<String> allNodeList = new ArrayList<String>();
                if (autoNodeListStr != null) {
                    allNodeList.addAll(Arrays.asList(autoNodeListStr.split(",")));
                }
                if (hubNodeListStr != null) {
                    allNodeList.addAll(Arrays.asList(hubNodeListStr.split(",")));
                }
                if (rimNodeListStr != null) {
                    allNodeList.addAll(Arrays.asList(rimNodeListStr.split(",")));
                }
                VerificationUtil.setLocalNodeFirst(allNodeList);
                this.m_nodeList = allNodeList.toArray(new String[0]);
            } else {
                try {
                    this.m_nodeList = VerificationUtil.getNodelist();
                }
                catch (NodelistNotFoundException e) {
                    throw new ComponentInitException(e.getMessage());
                }
            }
            this.initNodeManager();
        }
    }

    protected NodeManager initNodeManager() throws ComponentInitException {
        if (this.m_nodeList == null) {
            Trace.out((String)"m_nodeList is not initialized");
            throw new ComponentInitException(s_msgBundle.getMessage("7508", true));
        }
        try {
            NodeManagerFactory nmf;
            String autoNodeListStr = VerificationUtil.getVariableValue("AUTO_LIST");
            String hubNodeListStr = VerificationUtil.getVariableValue("HUB_LIST");
            String rimNodeListStr = VerificationUtil.getVariableValue("RIM_LIST");
            String targetHubSizeStr = VerificationUtil.getVariableValue("TARGET_HUB_SIZE");
            if (autoNodeListStr != null || hubNodeListStr != null || rimNodeListStr != null) {
                Trace.out((String)"Creating NodeMamanger with autoNodes=%s, hubNodes=%s, rimNodes=%s, targetHubSize=%s", (Object[])new Object[]{autoNodeListStr, hubNodeListStr, rimNodeListStr, targetHubSizeStr});
                int targetHubSize = 0;
                String[] autoNodeList = null;
                String[] hubNodeList = null;
                String[] rimNodeList = null;
                if (autoNodeListStr != null) {
                    autoNodeList = autoNodeListStr.split(",");
                }
                if (hubNodeListStr != null) {
                    hubNodeList = hubNodeListStr.split(",");
                }
                if (rimNodeListStr != null) {
                    rimNodeList = rimNodeListStr.split(",");
                }
                if (targetHubSizeStr != null) {
                    targetHubSize = Integer.parseInt(targetHubSizeStr);
                } else {
                    if (autoNodeList != null) {
                        targetHubSize = autoNodeList.length;
                    }
                    if (hubNodeList != null) {
                        targetHubSize += hubNodeList.length;
                    }
                }
                NodeManagerFactory nmf2 = NodeManagerFactory.getInstance();
                return nmf2.getNodeManager(hubNodeList, rimNodeList, autoNodeList, targetHubSize);
            }
            String crsHome = null;
            String haHome = null;
            boolean crsRunning = false;
            boolean haRunning = false;
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            try {
                if (VerificationUtil.isCRSConfigured()) {
                    crsHome = VerificationUtil.getCRSHome();
                    Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj(true);
                    if (crsActiveVersion != null && VerificationUtil.isStringGood(crsHome)) {
                        crsRunning = clusterwareInfo.isCRSRunning(crsHome, crsActiveVersion);
                    }
                } else if (VerificationUtil.isHAConfigured()) {
                    haHome = VerificationUtil.getHAHome();
                    haRunning = clusterwareInfo.isHARunning(haHome);
                }
            }
            catch (InstallException e) {
                Trace.out((String)("InstallException :" + e.getMessage()));
                crsRunning = false;
                haRunning = false;
            }
            if (crsRunning || haRunning) {
                Trace.out((String)"CRS is configured. Creating node manager without any arguments");
                nmf = NodeManagerFactory.getInstance();
                return nmf.getNodeManager();
            }
            Trace.out((String)("both CRS or HA is not running. creating nodeManager with node list " + VerificationUtil.strArr2List(this.m_nodeList)));
            nmf = NodeManagerFactory.getInstance();
            return nmf.getNodeManager(this.m_nodeList);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new ComponentInitException(nmfEx.getMessage());
        }
    }

    protected boolean validateEnvironment() {
        MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
        ErrorDescription errDesc = null;
        if (VerificationUtil.isHAConfigured()) {
            String msg = theMB.getMessage("5740", true);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            Trace.out((String)msg);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        if (!VerificationUtil.isCRSConfigured()) {
            String msg = theMB.getMessage("1016", true, (Object[])new String[]{this.getComponentDisplayName()});
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            Trace.out((String)msg);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return true;
    }

    protected boolean checkSetup() {
        String[] equivNodes;
        boolean succ = false;
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        if (VerificationUtil.isLocalNodeOperation()) {
            equivNodes = this.getNodeList();
        } else {
            equivNodes = VerificationUtil.getUserEquivalentNodes(this.getNodeList(), this.getResultSet());
            if (null == equivNodes) {
                succ = false;
                return false;
            }
        }
        boolean destLocSucc = VerificationUtil.checkDestLoc(equivNodes, this.getResultSet(), succNodes, failNodes, true);
        if (succNodes.size() > 0) {
            String[] tempNodeList = succNodes.toArray(new String[succNodes.size()]);
            this.setValidNodeList(tempNodeList);
        }
        succ = succNodes.size() == this.getNodeList().length;
        Trace.out((String)("succNodes passed setupChecks: " + VerificationUtil.strVect2List(succNodes)));
        return succ;
    }

    protected String[] getNodeList() {
        return this.m_nodeList;
    }

    protected void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    protected String[] getValidNodeList() {
        return this.m_validNodeList;
    }

    protected void setValidNodeList(String[] validNodeList) {
        this.m_validNodeList = validNodeList;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public abstract boolean verify();

    public final int getVerificationType() {
        return this.m_verificationType;
    }

    Component(int verificationType) throws ComponentInitException {
        this.m_verificationType = verificationType;
    }

    public abstract String getComponentName();

    public abstract String getComponentDisplayName();
}

